--
-- NOTE:
--
-- File paths need to be edited. Search for $$PATH$$ and
-- replace it with the path to the directory containing
-- the extracted data files.
--
--
-- PostgreSQL database dump
--

-- Dumped from database version 17.4 (Debian 17.4-1.pgdg120+2)
-- Dumped by pg_dump version 17.5

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

DROP DATABASE bevents;
--
-- Name: bevents; Type: DATABASE; Schema: -; Owner: bevents
--

CREATE DATABASE bevents WITH TEMPLATE = template0 ENCODING = 'UTF8' LOCALE_PROVIDER = libc LOCALE = 'en_US.utf8';


ALTER DATABASE bevents OWNER TO bevents;

\connect bevents

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: competition_mapping_sofa; Type: TABLE; Schema: public; Owner: bevents
--

CREATE TABLE public.competition_mapping_sofa (
    country character varying NOT NULL,
    competition_name character varying NOT NULL,
    canonical_name character varying NOT NULL
);


ALTER TABLE public.competition_mapping_sofa OWNER TO bevents;

--
-- Name: event_state_sofa; Type: TABLE; Schema: public; Owner: bevents
--

CREATE TABLE public.event_state_sofa (
    sport character varying NOT NULL,
    country character varying NOT NULL,
    competition character varying NOT NULL,
    event_name character varying NOT NULL,
    event_subject character varying NOT NULL,
    last_update timestamp with time zone,
    total_events integer,
    last_occurence integer,
    gaps integer[],
    gaps_length integer,
    percentage double precision,
    num_odds integer,
    sum_odds double precision,
    odds_avg double precision
);


ALTER TABLE public.event_state_sofa OWNER TO bevents;

--
-- Name: event_stats_sofa; Type: TABLE; Schema: public; Owner: bevents
--

CREATE TABLE public.event_stats_sofa (
    match_date timestamp with time zone NOT NULL,
    sport character varying NOT NULL,
    country character varying NOT NULL,
    competition character varying NOT NULL,
    home_team character varying NOT NULL,
    away_team character varying NOT NULL,
    proof character varying NOT NULL,
    event_name character varying NOT NULL,
    event_subject character varying NOT NULL,
    event_happened boolean,
    total_events integer,
    last_occurence integer,
    gaps integer[],
    percentage double precision,
    odds double precision,
    num_odds integer,
    sum_odds double precision,
    odds_avg double precision
);


ALTER TABLE public.event_stats_sofa OWNER TO bevents;

--
-- Name: matches_football_sofa; Type: TABLE; Schema: public; Owner: bevents
--

CREATE TABLE public.matches_football_sofa (
    match_date timestamp with time zone NOT NULL,
    country character varying NOT NULL,
    competition character varying NOT NULL,
    raw_competition character varying NOT NULL,
    home_team character varying NOT NULL,
    away_team character varying NOT NULL,
    stats_ft_home_goals integer,
    stats_ft_away_goals integer,
    stats_ht_home_goals integer,
    stats_ht_away_goals integer,
    stats_ft_home_corners integer,
    stats_ft_away_corners integer,
    stats_ft_yellow_cards_home integer,
    stats_ft_yellow_cards_away integer,
    stats_ft_red_cards_home integer,
    stats_ft_red_cards_away integer,
    odds_ft_1 double precision,
    odds_ht_1 double precision,
    odds_ft_2 double precision,
    odds_ht_2 double precision,
    odds_ft_x double precision,
    odds_ht_x double precision,
    odds_ft_1x double precision,
    odds_ft_x2 double precision,
    odds_ft_12 double precision,
    odds_ft_drawnobet1 double precision,
    odds_ft_drawnobet2 double precision,
    odds_ft_bothteamsscore_yes double precision,
    odds_ft_bothteamsscore_no double precision,
    odds_ft_goals_0_5_under double precision,
    odds_ft_goals_0_5_over double precision,
    odds_ft_goals_1_5_under double precision,
    odds_ft_goals_1_5_over double precision,
    odds_ft_goals_2_5_under double precision,
    odds_ft_goals_2_5_over double precision,
    odds_ft_goals_3_5_under double precision,
    odds_ft_goals_3_5_over double precision,
    odds_ft_goals_4_5_under double precision,
    odds_ft_goals_4_5_over double precision,
    odds_ft_goals_5_5_under double precision,
    odds_ft_goals_5_5_over double precision,
    odds_ft_goals_6_5_under double precision,
    odds_ft_goals_6_5_over double precision,
    odds_ft_goals_7_5_under double precision,
    odds_ft_goals_7_5_over double precision,
    odds_ft_firstteamtoscore_home double precision,
    odds_ft_firstteamtoscore_away double precision,
    odds_ft_firstteamtoscore_none double precision,
    odds_ft_asiah_home_name character varying,
    odds_ft_asiah_home_val double precision,
    odds_ft_asiah_away_name character varying,
    odds_ft_asiah_away_val double precision,
    odds_ft_corners_limit double precision,
    odds_ft_corners_over double precision,
    odds_ft_corners_under double precision
);


ALTER TABLE public.matches_football_sofa OWNER TO bevents;

--
-- Data for Name: competition_mapping_sofa; Type: TABLE DATA; Schema: public; Owner: bevents
--

COPY public.competition_mapping_sofa (country, competition_name, canonical_name) FROM stdin;
\.
COPY public.competition_mapping_sofa (country, competition_name, canonical_name) FROM '$$PATH$$/3374.dat';

--
-- Data for Name: event_state_sofa; Type: TABLE DATA; Schema: public; Owner: bevents
--

COPY public.event_state_sofa (sport, country, competition, event_name, event_subject, last_update, total_events, last_occurence, gaps, gaps_length, percentage, num_odds, sum_odds, odds_avg) FROM stdin;
\.
COPY public.event_state_sofa (sport, country, competition, event_name, event_subject, last_update, total_events, last_occurence, gaps, gaps_length, percentage, num_odds, sum_odds, odds_avg) FROM '$$PATH$$/3376.dat';

--
-- Data for Name: event_stats_sofa; Type: TABLE DATA; Schema: public; Owner: bevents
--

COPY public.event_stats_sofa (match_date, sport, country, competition, home_team, away_team, proof, event_name, event_subject, event_happened, total_events, last_occurence, gaps, percentage, odds, num_odds, sum_odds, odds_avg) FROM stdin;
\.
COPY public.event_stats_sofa (match_date, sport, country, competition, home_team, away_team, proof, event_name, event_subject, event_happened, total_events, last_occurence, gaps, percentage, odds, num_odds, sum_odds, odds_avg) FROM '$$PATH$$/3375.dat';

--
-- Data for Name: matches_football_sofa; Type: TABLE DATA; Schema: public; Owner: bevents
--

COPY public.matches_football_sofa (match_date, country, competition, raw_competition, home_team, away_team, stats_ft_home_goals, stats_ft_away_goals, stats_ht_home_goals, stats_ht_away_goals, stats_ft_home_corners, stats_ft_away_corners, stats_ft_yellow_cards_home, stats_ft_yellow_cards_away, stats_ft_red_cards_home, stats_ft_red_cards_away, odds_ft_1, odds_ht_1, odds_ft_2, odds_ht_2, odds_ft_x, odds_ht_x, odds_ft_1x, odds_ft_x2, odds_ft_12, odds_ft_drawnobet1, odds_ft_drawnobet2, odds_ft_bothteamsscore_yes, odds_ft_bothteamsscore_no, odds_ft_goals_0_5_under, odds_ft_goals_0_5_over, odds_ft_goals_1_5_under, odds_ft_goals_1_5_over, odds_ft_goals_2_5_under, odds_ft_goals_2_5_over, odds_ft_goals_3_5_under, odds_ft_goals_3_5_over, odds_ft_goals_4_5_under, odds_ft_goals_4_5_over, odds_ft_goals_5_5_under, odds_ft_goals_5_5_over, odds_ft_goals_6_5_under, odds_ft_goals_6_5_over, odds_ft_goals_7_5_under, odds_ft_goals_7_5_over, odds_ft_firstteamtoscore_home, odds_ft_firstteamtoscore_away, odds_ft_firstteamtoscore_none, odds_ft_asiah_home_name, odds_ft_asiah_home_val, odds_ft_asiah_away_name, odds_ft_asiah_away_val, odds_ft_corners_limit, odds_ft_corners_over, odds_ft_corners_under) FROM stdin;
\.
COPY public.matches_football_sofa (match_date, country, competition, raw_competition, home_team, away_team, stats_ft_home_goals, stats_ft_away_goals, stats_ht_home_goals, stats_ht_away_goals, stats_ft_home_corners, stats_ft_away_corners, stats_ft_yellow_cards_home, stats_ft_yellow_cards_away, stats_ft_red_cards_home, stats_ft_red_cards_away, odds_ft_1, odds_ht_1, odds_ft_2, odds_ht_2, odds_ft_x, odds_ht_x, odds_ft_1x, odds_ft_x2, odds_ft_12, odds_ft_drawnobet1, odds_ft_drawnobet2, odds_ft_bothteamsscore_yes, odds_ft_bothteamsscore_no, odds_ft_goals_0_5_under, odds_ft_goals_0_5_over, odds_ft_goals_1_5_under, odds_ft_goals_1_5_over, odds_ft_goals_2_5_under, odds_ft_goals_2_5_over, odds_ft_goals_3_5_under, odds_ft_goals_3_5_over, odds_ft_goals_4_5_under, odds_ft_goals_4_5_over, odds_ft_goals_5_5_under, odds_ft_goals_5_5_over, odds_ft_goals_6_5_under, odds_ft_goals_6_5_over, odds_ft_goals_7_5_under, odds_ft_goals_7_5_over, odds_ft_firstteamtoscore_home, odds_ft_firstteamtoscore_away, odds_ft_firstteamtoscore_none, odds_ft_asiah_home_name, odds_ft_asiah_home_val, odds_ft_asiah_away_name, odds_ft_asiah_away_val, odds_ft_corners_limit, odds_ft_corners_over, odds_ft_corners_under) FROM '$$PATH$$/3377.dat';

--
-- Name: competition_mapping_sofa competition_mapping_pkey1; Type: CONSTRAINT; Schema: public; Owner: bevents
--

ALTER TABLE ONLY public.competition_mapping_sofa
    ADD CONSTRAINT competition_mapping_pkey1 PRIMARY KEY (country, competition_name, canonical_name);


--
-- Name: event_state_sofa event_state_sofa_pkey; Type: CONSTRAINT; Schema: public; Owner: bevents
--

ALTER TABLE ONLY public.event_state_sofa
    ADD CONSTRAINT event_state_sofa_pkey PRIMARY KEY (sport, country, competition, event_name, event_subject);


--
-- Name: event_stats_sofa event_stats_sofa_pkey; Type: CONSTRAINT; Schema: public; Owner: bevents
--

ALTER TABLE ONLY public.event_stats_sofa
    ADD CONSTRAINT event_stats_sofa_pkey PRIMARY KEY (match_date, sport, event_name, country, competition, home_team, away_team, event_subject);


--
-- Name: matches_football_sofa matches_football_sofa_pkey1; Type: CONSTRAINT; Schema: public; Owner: bevents
--

ALTER TABLE ONLY public.matches_football_sofa
    ADD CONSTRAINT matches_football_sofa_pkey1 PRIMARY KEY (match_date, country, competition, home_team, away_team);


--
-- PostgreSQL database dump complete
--

